/* eslint-disable max-len */
define([
    'underscore',
    'marionette',
    'text!modules/page/content/_primary-header.html',
], function(_, Mn, template) {
    'use strict';


    /**
     * @class FormHeaderView
     * @typedef {Backbone.View<Backbone.Model>}
     */
    return Mn.View.extend({
        template: _.template(template),

        triggers: {'click #back-btn': 'navigate:appointments'},

        templateContext: function() {
            return {
                heading: 'New Appointment/Request',
                options: {
                    leftBtn: {
                        id: 'back-btn',
                        icon: 'ui-icon-carat-l',
                        style: 'phone-btn-notext ui-btn-icon-left',
                        title: 'Return to Appointments and Requests',
                        htmlText: '<span aria-hidden="true" role="presentation" class="phone-hidden">Appointments/Requests</span>',
                    },
                },
            };
        },
    });
});
